<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Doctor extends Model 
{

    protected $table = 'doctors';
    public $timestamps = false;

    public function user()
    {
        return $this->belongsTo('User');
    }

    public function assitants()
    {
        return $this->hasMany('AssistantDoctor');
    }

    public function specializations()
    {
        return $this->hasMany('DoctorSpecialization');
    }

    public function operations()
    {
        return $this->hasMany('Operation');
    }

}